<?php
include "../../conn.php";
include "../../functions2.php";

header('Content-Type: application/json; charset=utf-8');
header('Strict-Transport-Security: max-age=31536000');
header('Access-Control-Allow-Headers: Origin, X-Requested-With, Content-Type, Accept, Authorization');
header('Access-Control-Allow-Credentials: true');
$origin = isset($_SERVER['HTTP_ORIGIN']) ? $_SERVER['HTTP_ORIGIN'] : '';
header('Access-Control-Allow-Origin: ' . $origin);
header('vary: Origin');

date_default_timezone_set("Asia/Kolkata");
$shnunc = date("Y-m-d H:i:s");

// Default response for GET requests
$res = [
    'code' => 11,
    'msg' => 'Method not allowed',
    'msgCode' => 12,
    'serviceNowTime' => $shnunc,
];

$shonubody = file_get_contents("php://input");
$shonupost = json_decode($shonubody, true);

// Only accept POST requests
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode($res);
    exit;
}

// Check required parameters
if (!isset($shonupost['language'], $shonupost['random'], $shonupost['signature'], $shonupost['timestamp'])) {
    $res['code'] = 7;
    $res['msg'] = 'Param is Invalid';
    $res['msgCode'] = 6;
    http_response_code(400);
    echo json_encode($res);
    exit;
}

// Sanitize inputs
$language = htmlspecialchars(mysqli_real_escape_string($conn, $shonupost['language']));
$random = htmlspecialchars(mysqli_real_escape_string($conn, $shonupost['random']));
$signature = htmlspecialchars(mysqli_real_escape_string($conn, $shonupost['signature']));

// Verify signature
$shonustr = '{"language":'.$language.',"random":"'.$random.'"}';
$shonusign = strtoupper(md5($shonustr));

if ($shonusign !== $signature) {
    $res['code'] = 5;
    $res['msg'] = 'Wrong signature';
    $res['msgCode'] = 3;
    http_response_code(400);
    echo json_encode($res);
    exit;
}

// Get JWT from Authorization header
$bearer = explode(" ", $_SERVER['HTTP_AUTHORIZATION'] ?? '');
$author = $bearer[1] ?? '';
if (!$author) {
    $res['code'] = 6;
    $res['msg'] = 'Authorization token missing';
    $res['msgCode'] = 4;
    http_response_code(401);
    echo json_encode($res);
    exit;
}

// Decode JWT payload
function decode_jwt_payload($jwt) {
    $parts = explode('.', $jwt);
    if(count($parts) !== 3) return null;
    $payload = $parts[1];
    $decoded = json_decode(base64_decode(strtr($payload, '-_', '+/')), true);
    return $decoded;
}

$jwt_payload = decode_jwt_payload($author);
if (!$jwt_payload || !isset($jwt_payload['id'])) {
    $res['code'] = 4;
    $res['msg'] = 'Invalid JWT';
    $res['msgCode'] = 2;
    http_response_code(401);
    echo json_encode($res);
    exit;
}

$user_id = $jwt_payload['id'];

// Check if JWT exists in subjects table
$sesquery = "SELECT akshinak FROM shonu_subjects WHERE akshinak = ?";
$stmt_ses = $conn->prepare($sesquery);
$stmt_ses->bind_param("s", $author);
$stmt_ses->execute();
$stmt_ses->store_result();
$sesnum = $stmt_ses->num_rows;
$stmt_ses->close();

if ($sesnum !== 1) {
    $res['code'] = 4;
    $res['msg'] = 'No operation permission';
    $res['msgCode'] = 2;
    http_response_code(401);
    echo json_encode($res);
    exit;
}

// Fetch motta for the user
$balquery = "SELECT motta FROM shonu_kaichila WHERE balakedara = ?";
$stmt_bal = $conn->prepare($balquery);
$stmt_bal->bind_param("i", $user_id);
$stmt_bal->execute();
$result_bal = $stmt_bal->get_result();
$balarr = $result_bal->fetch_assoc();
$stmt_bal->close();
$data['amount'] = $balarr['motta'];

$res['data'] = $data;
$res['code'] = 0;
$res['msg'] = 'Succeed';
$res['msgCode'] = 0;
http_response_code(200);
echo json_encode($res);
?>
