<?php
    include "../../conn.php";
    include "../../functions2.php";

    header('Content-Type: application/json; charset=utf-8');
    header('Access-Control-Allow-Origin: *');
    header('Access-Control-Allow-Headers: Origin, X-Requested-With, Content-Type, Accept, Authorization');
    header('Access-Control-Allow-Credentials: true');

    date_default_timezone_set("Asia/Kolkata");
    $currentTime = date("Y-m-d H:i:s");

    // Default response
    $response = [
        'code' => 11,
        'msg' => 'Method not allowed',
        'msgCode' => 12,
        'serviceNowTime' => $currentTime,
    ];

    if ($_SERVER['REQUEST_METHOD'] == 'POST') {
        $requestBody = file_get_contents("php://input");
        $postData = json_decode($requestBody, true);

        if (isset($postData['language']) && isset($postData['random']) && isset($postData['signature']) && isset($postData['timestamp'])) {
            $language = htmlspecialchars(mysqli_real_escape_string($conn, $postData['language']));
            $random = htmlspecialchars(mysqli_real_escape_string($conn, $postData['random']));
            $signature = htmlspecialchars(mysqli_real_escape_string($conn, $postData['signature']));
            $timestamp = htmlspecialchars(mysqli_real_escape_string($conn, $postData['timestamp']));

            // **आपका डेटा प्रोसेसिंग लॉजिक यहां होगा**
            $safeAmount = 500; // Example static value
            $shareAmount = 100; // Example static value

            $response = [
                'code' => 0,
                'msg' => 'Succeed',
                'msgCode' => 0,
                'data' => [
                    'state' => '1',
                    'shareTime' => 1,
                    'dayShareRate' => 0.00100,
                    'userDayShareRate' => 0.00100,
                    'safeAmount' => $safeAmount,
                    'safeEarnings' => null,
                    'willSafeEarnings' => null,
                    'safeTotalAmount' => null,
                    'shareAmount' => $shareAmount,
                    'safeBoxCodeAmount' => 0,
                    'isOpenNewSetting' => '0',
                    'maxSafeAmount' => null,
                ],
                'serviceNowTime' => $currentTime,
            ];
            http_response_code(200);
        } else {
            $response = [
                'code' => 7,
                'msg' => 'Invalid parameters',
                'msgCode' => 6,
                'serviceNowTime' => $currentTime,
            ];
            http_response_code(400);
        }
    } else {
        http_response_code(405);
    }

    echo json_encode($response);
?>