<?php
header("Content-Type: application/json; charset=UTF-8");

// Authorization चेक करें
$headers = apache_request_headers();
if (!isset($headers['Authorization'])) {
    echo json_encode(["code" => 401, "msg" => "Unauthorized"]);
    exit;
}

// Request body से JSON डेटा प्राप्त करें
$inputJSON = file_get_contents('php://input');
$inputData = json_decode($inputJSON, true);

// अगर request JSON format में नहीं है या ज़रूरी data missing है
if (!$inputData || !isset($inputData["month"], $inputData["pageNo"], $inputData["pageSize"], $inputData["random"], $inputData["signature"], $inputData["timestamp"])) {
    echo json_encode(["code" => 400, "msg" => "Bad Request"]);
    exit;
}

// Sample response data
$response = [
    "data" => [
        "extend1" => 0.0,
        "extend2" => 0.0,
        "extend3" => 0.0,
        "list" => [], // Empty list
        "pageNo" => $inputData["pageNo"],
        "totalPage" => 0,
        "totalCount" => 0
    ],
    "code" => 0,
    "msg" => "Succeed",
    "msgCode" => 0,
    "serviceNowTime" => date("Y-m-d H:i:s") // Server का current time
];

// JSON response वापस भेजें
echo json_encode($response);
?>