<?php
include "../../conn.php";
include "../../functions2.php";

header('Content-Type: application/json; charset=utf-8');
header('Strict-Transport-Security: max-age=31536000');
header('Access-Control-Allow-Headers: Origin, X-Requested-With, Content-Type, Accept, Authorization');
header('Access-Control-Allow-Credentials: true');
$origin = isset($_SERVER['HTTP_ORIGIN']) ? $_SERVER['HTTP_ORIGIN'] : '';
header('Access-Control-Allow-Origin: ' . $origin);
header('Vary: Origin');

date_default_timezone_set("Asia/Kolkata");
$now = date("Y-m-d H:i:s");

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $input = file_get_contents("php://input");
    $postData = json_decode($input, true);

    if (isset($postData['language']) && isset($postData['random']) && isset($postData['signature']) && isset($postData['timestamp'])) {
        $language = htmlspecialchars(mysqli_real_escape_string($conn, $postData['language']));
        $random = htmlspecialchars(mysqli_real_escape_string($conn, $postData['random']));
        $signature = htmlspecialchars(mysqli_real_escape_string($conn, $postData['signature']));
        $str = '{"language":' . $language . ',"random":"' . $random . '"}';
        $calcSignature = strtoupper(md5($str));

        if ($calcSignature === $signature) {
            $bearer = explode(" ", $_SERVER['HTTP_AUTHORIZATION']);
            $token = $bearer[1];
            $jwtValid = is_jwt_valid($token);
            $authData = json_decode($jwtValid, true);

            if ($authData['status'] === 'Success') {
                $userQuery = "SELECT id FROM shonu_subjects WHERE akshinak = ?";
                $stmt = $conn->prepare($userQuery);
                $stmt->bind_param("s", $token);
                $stmt->execute();
                $userResult = $stmt->get_result();

                if ($userResult->num_rows > 0) {
                    $userRow = $userResult->fetch_assoc();
                    $userId = $userRow['id'];

                    // Fetch total balance from provider_balances
                    $balanceQuery = "SELECT SUM(balance) as total_balance FROM provider_balances WHERE user_id = ?";
                    $stmt = $conn->prepare($balanceQuery);
                    $stmt->bind_param("i", $userId);
                    $stmt->execute();
                    $balanceResult = $stmt->get_result();
                    $balanceRow = $balanceResult->fetch_assoc();
                    $totalBalance = (float)$balanceRow['total_balance'];

                    if ($totalBalance > 0) {
                        $conn->begin_transaction();
                        try {
                            // Transfer balance to shonu_kaichila
                            $transferQuery = "UPDATE shonu_kaichila SET motta = motta + ? WHERE balakedara = ?";
                            $stmt = $conn->prepare($transferQuery);
                            $stmt->bind_param("di", $totalBalance, $userId);
                            $stmt->execute();

                            // Reset provider_balances to zero
                            $resetQuery = "UPDATE provider_balances SET balance = 0 WHERE user_id = ?";
                            $stmt = $conn->prepare($resetQuery);
                            $stmt->bind_param("i", $userId);
                            $stmt->execute();

                            // Insert "Game moved out" transaction
                            $remark = "Transferred $totalBalance to main wallet";
                            $transQuery = "INSERT INTO game_trans_out (user_id, amount, remark, created_at) VALUES (?, ?, ?, ?)";
                            $stmt = $conn->prepare($transQuery);
                            $stmt->bind_param("idss", $userId, $totalBalance, $remark, $now);
                            $stmt->execute();

                            $conn->commit();

                            // Success response
                            $response = [
                                "data" => [
                                    "amount" => number_format($totalBalance, 2, '.', ''),
                                    "uRate" => 93.5,
                                    "uGold" => number_format($totalBalance / 100, 2, '.', '')
                                ],
                                "code" => 0,
                                "msg" => "Balance transferred successfully",
                                "msgCode" => 0,
                                "serviceNowTime" => $now
                            ];
                            http_response_code(200);
                            echo json_encode($response);
                        } catch (Exception $e) {
                            $conn->rollback();
                            http_response_code(500);
                            echo json_encode(["code" => 10, "msg" => "Transfer failed: " . $e->getMessage()]);
                        }
                    } else {
                        http_response_code(200);
                        echo json_encode([
                            "code" => 0,
                            "msg" => "No balance in 3rd Party Wallet to transfer",
                            "msgCode" => 8,
                            "serviceNowTime" => $now
                        ]);
                    }
                } else {
                    http_response_code(404);
                    echo json_encode(["code" => 6, "msg" => "User not found"]);
                }
            } else {
                http_response_code(401);
                echo json_encode(["code" => 4, "msg" => "No operation permission", "msgCode" => 2]);
            }
        } else {
            http_response_code(200);
            echo json_encode(["code" => 5, "msg" => "Wrong signature", "msgCode" => 3]);
        }
    } else {
        http_response_code(200);
        echo json_encode(["code" => 7, "msg" => "Invalid parameters", "msgCode" => 6]);
    }
} else {
    http_response_code(405);
    echo json_encode(["code" => 11, "msg" => "Method not allowed", "msgCode" => 12, "serviceNowTime" => $now]);
}
?>