<?php
header("Content-Type: application/json");

// Input JSON डेटा प्राप्त करें
$inputJSON = file_get_contents("php://input");
$inputData = json_decode($inputJSON, true);

// Authorization Token Check (Optional)
$headers = getallheaders();
$authHeader = isset($headers['Authorization']) ? $headers['Authorization'] : null;

// Validate Authorization Token (Basic Check)
if (!$authHeader || strpos($authHeader, 'Bearer ') !== 0) {
    echo json_encode(["code" => 401, "msg" => "Unauthorized"]);
    exit;
}

// Pagination Parameters (Default values if not set)
$pageSize = isset($inputData["pageSize"]) ? intval($inputData["pageSize"]) : 10;
$pageNo = isset($inputData["pageNo"]) ? intval($inputData["pageNo"]) : 1;

// Sample Data (आप इसे डेटाबेस से भी ला सकते हैं)
$allData = [
    
];

// Total डेटा Count
$totalCount = count($allData);
$totalPage = ceil($totalCount / $pageSize);

// Pagination Logic
$offset = ($pageNo - 1) * $pageSize;
$paginatedData = array_slice($allData, $offset, $pageSize);

// JSON Response
$response = [
    "data" => [
        "list" => $paginatedData,
        "pageNo" => $pageNo,
        "totalPage" => $totalPage,
        "totalCount" => $totalCount
    ],
    "code" => 0,
    "msg" => "Succeed",
    "msgCode" => 0,
    "serviceNowTime" => date("Y-m-d H:i:s")
];

echo json_encode($response);
?>