<?php
// ==========================================
// 🔹 Configuration
// ==========================================
include 'serive/samparka.php'; // Must define $conn (MySQLi connection)

$bot_token = "6163828329:AAEdwQbhW8pYjm2Vvl_gRUeO3-P0WAxA5-o";
$chat_id   = "6152356783";

header("Content-Type: application/json; charset=utf-8");
date_default_timezone_set("Asia/Kolkata");

// ==========================================
// 🔹 Telegram Notification Helper
// ==========================================
function sendTelegramMessage($bot_token, $chat_id, $message)
{
    $url = "https://api.telegram.org/bot$bot_token/sendMessage";
    $post_fields = [
        'chat_id' => $chat_id,
        'text' => $message,
        'parse_mode' => 'HTML'
    ];

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $post_fields);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_exec($ch);
    curl_close($ch);
}

// ==========================================
// 🔹 Allow only POST Requests
// ==========================================
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    $msg = "❌ Only POST requests are allowed.";
    echo json_encode(['success' => false, 'message' => $msg]);
    exit;
}

// ==========================================
// 🔹 Collect POST data safely
// ==========================================
$status           = $_POST['status'] ?? null;
$order_id         = $_POST['order_id'] ?? null;
$customer_mobile  = $_POST['customer_mobile'] ?? null;
$amount           = $_POST['amount'] ?? null;
$remark1          = $_POST['remark1'] ?? null;
$remark2          = $_POST['remark2'] ?? null;

// Decode remark2 JSON safely
$some = json_decode($remark2, true);
if (json_last_error() !== JSON_ERROR_NONE) {
    http_response_code(400);
    $msg = "❌ Invalid JSON in remark2.";
    sendTelegramMessage($bot_token, $chat_id, $msg);
    echo json_encode(['success' => false, 'message' => $msg]);
    exit;
}

$uid   = $some['userId'] ?? null;
$sign  = $some['signature'] ?? null;
$tyid  = $some['transactionId'] ?? null;

// ==========================================
// 🔹 Validate Required Fields
// ==========================================
$required = [
    'status'         => $status,
    'order_id'       => $order_id,
    'customer_mobile'=> $customer_mobile,
    'amount'         => $amount,
    'userId'         => $uid,
    'transactionId'  => $tyid
];

$missing = [];
foreach ($required as $key => $val) {
    if ($val === null || $val === '') {
        $missing[] = $key;
    }
}

if (!empty($missing)) {
    http_response_code(400);
    $msg = "❌ Missing required fields: " . implode(', ', $missing);
    sendTelegramMessage($bot_token, $chat_id, $msg);
    echo json_encode(['success' => false, 'message' => $msg]);
    exit;
}

// ==========================================
// 🔹 Prepare Payment Data
// ==========================================
$balakedara = $uid;
$motta = (float)$amount;
$payId = 11;
$mula = 'wepay';
$dharavahi = 'P' . date('YmdHis') . mt_rand(100000, 999999) . mt_rand(1000, 9999);
$ullekha = $order_id;
$duravani = $customer_mobile;
$ekikrtapavati = "BHARATPE.8O0Z0P5R6J12017@fbpe";
$dinankavannuracisi = date("Y-m-d H:i:s");
$madari = $tyid;
$pavatiaidi = 2;
$sthiti = ($status === 'SUCCESS') ? 1 : 0;

// ==========================================
// 🔹 Insert into thevani Table
// ==========================================
$sql = "INSERT INTO `thevani` 
(`payid`,`balakedara`,`motta`,`dharavahi`,`mula`,`ullekha`,
 `duravani`,`ekikrtapavati`,`dinankavannuracisi`,`madari`,`pavatiaidi`,`sthiti`)
VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";

$stmt = $conn->prepare($sql);
if (!$stmt) {
    http_response_code(500);
    $msg = "❌ Prepare failed: " . $conn->error;
    sendTelegramMessage($bot_token, $chat_id, $msg);
    echo json_encode(['success' => false, 'message' => $msg]);
    exit;
}

if (!$stmt->bind_param(
    "isdsssssssis",
    $payId,
    $balakedara,
    $motta,
    $dharavahi,
    $mula,
    $ullekha,
    $duravani,
    $ekikrtapavati,
    $dinankavannuracisi,
    $madari,
    $pavatiaidi,
    $sthiti
)) {
    http_response_code(500);
    $msg = "❌ Bind param failed: " . $stmt->error;
    sendTelegramMessage($bot_token, $chat_id, $msg);
    echo json_encode(['success' => false, 'message' => $msg]);
    exit;
}



if (!$stmt->execute()) {
    http_response_code(500);
    $msg = "❌ Execute failed: " . $stmt->error;
    sendTelegramMessage($bot_token, $chat_id, $msg);
    echo json_encode(['success' => false, 'message' => $msg]);
    exit;
}

// ==========================================
// 🔹 Update or Insert User Balance in shonu_kaichila
// ==========================================

// Check if user exists
$check_user = $conn->prepare("SELECT motta FROM shonu_kaichila WHERE balakedara = ?");
$check_user->bind_param("i", $balakedara);
$check_user->execute();
$result = $check_user->get_result();

if ($result->num_rows > 0) {
    // ✅ User exists → Update motta
    $update = $conn->prepare("UPDATE shonu_kaichila SET motta = motta + ? WHERE balakedara = ?");
    $update->bind_param("di", $motta, $balakedara);
    $update->execute();
    $update->close();
    $balance_msg = "💰 Existing user found. motta updated by ₹$motta.";
} else {
    // 🚀 User not found → Create new record
    $insert_user = $conn->prepare("INSERT INTO shonu_kaichila (balakedara, motta) VALUES (?, ?)");
    $insert_user->bind_param("id", $balakedara, $motta);
    $insert_user->execute();
    $insert_user->close();
    $balance_msg = "🆕 New user created with motta ₹$motta.";
}
$check_user->close();


// ==========================================
// 🔹 Success Response
// ==========================================
$msg = "✅ <b>Payment Recorded Successfully!</b>\n\n" .
       "💳 <b>Order ID:</b> $ullekha\n" .
       "👤 <b>User ID:</b> $balakedara\n" .
       "📱 <b>Mobile:</b> $duravani\n" .
       "💰 <b>Amount:</b> ₹$motta\n" .
       "🆔 <b>Transaction:</b> $madari\n" .
       "📅 <b>Date:</b> $dinankavannuracisi\n" .
       "📊 <b>Status:</b> " . ($sthiti ? "✅ SUCCESS" : "❌ FAILED");

sendTelegramMessage($bot_token, $chat_id, $msg);

http_response_code(200);
echo json_encode([
    'success' => true,
    'message' => 'Transaction recorded successfully.',
    'order_id' => $ullekha,
    'user_id' => $balakedara,
    'amount' => $motta,
    'status' => $sthiti ? 'SUCCESS' : 'FAILED',
    'timestamp' => $dinankavannuracisi
]);

$stmt->close();
$conn->close();
?>
