<?php 
include ("../serive/samparka.php"); // DB connection file

$params = $_GET;

// Initialize variables
$tyid = isset($params['tyid']) ? trim($params['tyid']) : '';
$amount = isset($params['amount']) ? trim($params['amount']) : '';
$uid = isset($params['uid']) ? trim($params['uid']) : '';
$sign = isset($params['sign']) ? trim($params['sign']) : '';
$urlInfo = isset($params['urlInfo']) ? trim($params['urlInfo']) : '';

$base_url = "https://wins999.in";

$errorMessage = "";

// Validate each variable
if (empty($tyid)) $errorMessage .= "❌ Missing transaction id.\n";
if (empty($amount)) $errorMessage .= "❌ Missing amount.\n";
if (empty($uid)) $errorMessage .= "❌ Missing user id.\n";
if (empty($sign)) $errorMessage .= "❌ Missing or Invalid Signature.\n";
if (empty($urlInfo)) $errorMessage .= "❌ Missing Redirect URL.\n";

// Fetch user data
$userData = null;
if (!empty($uid)) {
    $stmt = $conn->prepare("SELECT * FROM shonu_subjects WHERE id = ?");
    if ($stmt) {
        $stmt->bind_param("s", $uid);
        $stmt->execute();
        $result = $stmt->get_result();

        if ($result && $result->num_rows > 0) {
            $userData = $result->fetch_assoc();
        } else {
            $errorMessage .= "❌ Invalid user (No user found with id: $uid).\n";
        }

        $stmt->close();
    } else {
        $errorMessage .= "❌ Database query preparation failed.\n";
    }
}

// Prepare variables for API
$customer_mobile = $userData['mobile'] ?? '';
$customer_name = $userData['codechorkamukala'] ?? '';
$user_token = '90e708e3427c36f6492a0e36738405d7'; // Fixed token
$amount = abs((int)$amount);
$order_id = $tyid . time() . rand(1000, 9999);
$redirect_url = $base_url . "/#/wallet/RechargeHistory";
$remark1 = 'Payment for Order ID: ' . $order_id;
$remark2 = json_encode(['userId'=>$uid,'signature'=>$sign,'transactionId'=>$tyid]);

// Function to display error page
function displayErrorPage($message){
    $safeMessage = nl2br(htmlspecialchars($message));
    echo '<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Error</title>
<style>
    body, html {
        margin:0;
        padding:0;
        height:100%;
        display:flex;
        justify-content:center;
        align-items:center;
        background: linear-gradient(135deg,#f5f7fa,#c3cfe2);
        font-family: "Arial", sans-serif;
    }
    .error-card {
        background:#fff;
        border-left:6px solid #e74c3c;
        padding:30px 40px;
        border-radius:12px;
        max-width:500px;
        width:90%;
        box-shadow:0 10px 25px rgba(0,0,0,0.1);
        text-align:center;
        animation:fadeIn 0.6s ease-out;
    }
    .error-card h1 {
        margin:0 0 15px 0;
        color:#e74c3c;
        font-size:28px;
    }
    .error-card p {
        color:#333;
        font-size:16px;
        line-height:1.5;
    }
    .error-card button {
        margin-top:20px;
        padding:10px 20px;
        background:#e74c3c;
        color:#fff;
        border:none;
        border-radius:6px;
        font-size:16px;
        cursor:pointer;
        transition:0.3s;
    }
    .error-card button:hover {
        background:#c0392b;
    }
    @keyframes fadeIn {
        from {opacity:0; transform: translateY(-20px);}
        to {opacity:1; transform: translateY(0);}
    }
</style>
</head>
<body>
<div class="error-card">
    <h1>❌ Error</h1>
    <p>' . $safeMessage . '</p>
    <button onclick="history.back()">Go Back</button>
</div>
</body>
</html>';
    exit();
}

// Show validation errors if any
if (!empty($errorMessage)) displayErrorPage($errorMessage);

// Send POST request to API
$api_url = 'https://pay0.shop/api/create-order';
$post_data = [
    'customer_mobile' => $customer_mobile,
    'customer_name' => $customer_name,
    'user_token' => $user_token,
    'amount' => $amount,
    'order_id' => $order_id,
    'redirect_url' => $redirect_url,
    'remark1' => $remark1,
    'remark2' => $remark2
];

$ch = curl_init($api_url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($post_data));
curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/x-www-form-urlencoded']);

$response = curl_exec($ch);

if (curl_errno($ch)) {
    $curlError = 'cURL Error: ' . curl_error($ch);
    curl_close($ch);
    displayErrorPage($curlError);
}

curl_close($ch);

// Decode JSON response
$result = json_decode($response, true);

if ($result['status'] ?? false) {
    $payment_url = $result['result']['payment_url'] ?? '';
    if (!empty($payment_url)) {
        header("Location: $payment_url");
        exit();
    } else {
        displayErrorPage("❌ Payment URL not found in response.");
    }
} else {
    displayErrorPage("❌ API Error: " . ($result['message'] ?? 'Unknown error'));
}
?>